<?php

/*
	Copyright (C) 2008-2014, Rémi Jean (zwiicms@outlook.com)
	<http://zwiicms.com/>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General License for more details.

	You should have received a copy of the GNU General License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class contact extends zwii
{
	public function __construct()
	{
		parent::__construct();
	}
	public function home()
	{
		if($this->getPost('submit'))
		{
			if(sha1($this->getPost('captcha')) == $_SESSION['CAPTCHA'])
			{
				$this->send();
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('La somme saisie est incorrecte !');
				$_SESSION['TMP'] = array($this->getPost('mail'), $this->getPost('subject'), $this->getPost('message'));
			}
			return $this->redirect($this->getUrl());
		}
		else
		{
			$this->setTitle($this->getPluginVar('contact', 'title'));
			$this->setContent
			(
				'<form name="form" method="post">' .
				'<p>' .
				'<label>' . $this->_('Adresse mail') . '</label>' .
				'<input type="text" name="mail" class="medium" value="' . @$_SESSION['TMP'][0] . '" required>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Sujet') . '</label>' .
				'<input type="text" name="subject" class="medium" value="' . @$_SESSION['TMP'][1] . '" required>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Message') . '</label>' .
				'<textarea name="message" class="medium" required>' . @$_SESSION['TMP'][2] . '</textarea>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Qu\'elle est la somme de : ') . $this->captcha() . '</label>' .
				'<input type="text" name="captcha" class="small" required>' .
				'</p>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Envoyer') . '">' .
				'</p>' .
				'</form>'
			);
			if(!empty($_SESSION['TMP']))
			{
				unset($_SESSION['TMP']);
			}
		}
	}
	private function send()
	{
		$n = preg_match("#@(hotmail|live|msn|outlook).[a-z]{2,4}$#", $this->getPluginVar('contact', 'mail')) ? "\n" : "\r\n";
		$boundary = '-----=' . md5(rand());
		$html = '<html><head></head><body>' . $this->getPost('message') . '</body></html>';
		$txt = strip_tags($html);
		$header = 'From: ' . $this->getPost('mail') . $n;
		$header .= 'Reply-To: ' . $this->getPluginVar('contact', 'mail') . $n;
		$header .= 'MIME-Version: 1.0' . $n;
		$header .= 'Content-Type: multipart/alternative;' . $n . ' boundary="' . $boundary. '"' . $n;
		$message = $n . $boundary . $n;
		$message .= 'Content-Type: text/plain; charset="utf-8"' . $n;
		$message .= 'Content-Transfer-Encoding: 8bit' . $n;
		$message .= $n . $txt . $n;
		$message .= $n . '--' . $boundary . $n;
		$message .= 'Content-Type: text/html; charset="utf-8"' . $n;
		$message .= 'Content-Transfer-Encoding: 8bit' . $n;
		$message .= $n . $html . $n;
		$message .= $n . '--' . $boundary . '--' . $n;
		$message .= $n . '--' . $boundary . '--' . $n;
		if($this->getPluginVar('contact', 'mail')
		&& @mail($this->getPluginVar('contact', 'mail'), $this->getPost('subject'), $message, $header))
		{
			return $_SESSION['POPUP'] = $this->_('Mail envoyé avec succès !');
		}
		else
		{
			return $_SESSION['POPUP'] = $this->_('Impossible d\'envoyer le mail !');
		}
	}
	private function captcha()
	{
		$n = array(mt_rand(1, 50), mt_rand(1, 50));
		$_SESSION['CAPTCHA'] = sha1($n[0] + $n[1]);
		return $n[0] . ' + ' . $n[1] ;
	}
}

?>