<?php

/*
	Copyright (C) 2008-2014, Rémi Jean (zwiicms@outlook.com)
	<http://zwiicms.com/>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General License for more details.

	You should have received a copy of the GNU General License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class backups extends zwii
{
	private $_pattern;
	private $_backupsPath;

	public function __construct()
	{
		parent::__construct();
		$this->title = $this->_('Sauvegardes');
		$this->_pattern = '/\.(.*?)$/';
		$this->_backupsPath = $this->getDataPath() . 'backups/';
		if(!is_dir($this->_backupsPath))
		{
			mkdir($this->_backupsPath);
		}
	}
	public function home()
	{
		if($this->getPost('submit'))
		{
			$this->download();
			return $this->redirect($this->getUrl());
		}
		else
		{
			$this->setTitle('Sauvegardes');
			$this->setContent
			(
				'<form name="form" method="post">' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Sauvegarder') . '">' .
				'</p>' .
				'</form>' .
				'<table>' .
				'<thead>' .
				'<tr>' .
				'<th>' . $this->_('Date') . '</th>' .
				'<th>' . $this->_('Actions') . '</th>' .
				'</tr>' .
				'</thead>' .
				'<tbody>' .
				$this->backupsList() .
				'</tbody>' .
				'</table>'
			);
		}
	}
	public function delete()
	{
		if(file_exists($this->_backupsPath . $this->getUrlVal(2)))
		{
			if(unlink($this->_backupsPath . $this->getUrlVal(2)))
			{
				$_SESSION['POPUP'] = $this->_('Sauvegarde supprimée avec succès !');
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('Impossible de supprimer la sauvegarde !');
			}
			return $this->redirect('?backups');
		}
	}
	private function download()
	{
		$zip = new ZipArchive();
		if($zip->open($this->_backupsPath . time() . '.zip', ZipArchive::OVERWRITE) === true)
		{
			$zip->addPattern($this->_pattern, $this->getDataPath(), array('add_path' => 'data/', 'remove_all_path' => TRUE));
			$handle = opendir($this->getDataPath());
			while(false !== ($entry = readdir($handle)))
			{
				if(is_dir($this->getDataPath() . $entry . '/')
				&& $entry !== 'backups')
				{
					$zip->addPattern($this->_pattern, $this->getDataPath() . $entry, array('add_path' => 'data/' . $entry . '/', 'remove_all_path' => TRUE));
				}
			}
			closedir($handle);
			$zip->close();
			return $_SESSION['POPUP'] = $this->_('Sauvegarde effectuée avec succès !');
		}
		else
		{
			return $_SESSION['POPUP'] = $this->_('Impossible de sauvegarder les données !');
		}
	}
	private function backupsList()
	{
		$entries = array();
		$handle = opendir($this->_backupsPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_backupsPath . $entry))
			{
				$date = date($this->_('d/m/Y - H:i:s'), basename($entry, '.zip'));
				$entries[$entry] = $date;
			}
		}
		closedir($handle);
		asort($entries, SORT_NUMERIC);
		foreach($entries as $key => $value)
		{
			@$backups .= '<tr>' .
				'<td>' . $value . '</td>' .
				'<td>' .
				'<a href="' . $this->_backupsPath . $key . '">' . $this->_('Télécharger') . '</a> ' .
				'<a href="?backups/delete/' . $key . '" onclick="return confirm(\'' . $this->_('Êtes-vous certain de vouloir supprimer cette sauvegarde ?') . '\');">' . $this->_('Supprimer') . '</a>' .
				'</td>' .
				'</tr>';
		}
		return empty($backups) ? '<tr><td colspan="2">' . $this->_('Aucune sauvegarde.') . '</td></tr>' : $backups;
	}
}

?>