<?php

/*
	Copyright (C) 2008-2014, Rémi Jean (zwiicms@outlook.com)
	<http://zwiicms.com/>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General License for more details.

	You should have received a copy of the GNU General License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

session_start();

class zwii
{
	private $_dataPath;
	private $_data;
	private $_linkPages;
	private $_positionsPages;
	private $_pluginsPath;
	private $_plugins;
	private $_languagesPath;
	private $_languagesList;
	private $_languages;
	private $_templatesPath;
	private $_templates;
	private $_url;
	private $_popup;
	private $_error;
	private $_title;
	private $_metaTitle;
	private $_content;
	const VERSION = '6.0.1';

	public function __construct()
	{
		$this->_dataPath = 'data/';
		$this->_data = $this->importData();
		ksort($this->_data['pages'], SORT_STRING);
		$this->_linkPages = $this->pagesExtracts('link');
		$this->_positionsPages = $this->pagesExtracts('position');
		ksort($this->_positionsPages, SORT_NUMERIC);
		$this->_pluginsPath = 'plugins/';
		$this->_plugins = array
		(
			'page' => array
			(
				'home' => true,
				'add' => false,
				'edit' => false,
				'delete' => false
			),
			'settings' => array
			(
				'home' => false
			),
			'plugins' => array
			(
				'home' => false
			),
			'user' => array
			(
				'logout' => false
			)
		);
		$this->_plugins = array_merge($this->_plugins, $this->importPlugins());
		$this->_languagesPath = 'system/languages/';
		$this->_languagesList = $this->listLanguages();
		$this->_languages = $this->importLanguages();
		$this->_templatesPath = 'templates/';
		$this->_templates = $this->importTemplates();
		$this->_url = !empty($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : 'page/' . $this->getSetting('home');
		$this->_url = explode('/', $this->_url);
		$this->_pluginUrl = 1;
		$this->_popup = empty($_SESSION['POPUP']) ? false : $_SESSION['POPUP'];
		$this->_error = '<p>' . $this->_('Page introuvable !') . '</p>';
		$this->_title = $this->_('Erreur 404');
		$this->_metaTitle = false;
		$this->_content = $this->_error;
	}

	/*
		Accesseurs et mutateurs
	*/

	public function getData($key)
	{
		return empty($this->_data[$key]) ? false : $this->_data[$key];
	}
	public function setData($file, $key)
	{
		$this->_data[$file] = $key;
	}
	public function setDataVal($file, $key, $value)
	{
		$this->_data[$file][$key] = $value;
	}
	public function removeData($file, $key)
	{
		unset($this->_data[$file][$key]);
	}
	public function getDataPath()
	{
		return $this->_dataPath;
	}
	public function getSetting($key)
	{
		return empty($this->_data['settings'][$key]) ? false : $this->_data['settings'][$key];
	}
	public function getPage($key)
	{
		return empty($this->_data['pages'][$key]) ? false : $this->_data['pages'][$key];
	}
	public function getPageVal($key, $value, $markdown = false)
	{
		if(empty($this->_data['pages'][$key][$value]))
		{
			return false;
		}
		else
		{
			return $markdown ? Parsedown::instance()->parse($this->_data['pages'][$key][$value]) : $this->_data['pages'][$key][$value];
		}
	}
	public function getLinkPage($key)
	{
		return empty($this->_linkPages[$key]) ? false : $this->_linkPages[$key];
	}
	public function getPositionsPages()
	{
		return $this->_positionsPages;
	}
	public function getPluginsPath()
	{
		return $this->_pluginsPath;
	}
	public function getPlugins()
	{
		return $this->_plugins;
	}
	public function getPlugin($plugin)
	{
		return empty($this->_plugins[$plugin]) ? false : $this->_plugins[$plugin];
	}
	public function getPluginKey($plugin, $key)
	{
		return empty($this->_plugins[$plugin][$key]) ? false : $this->_plugins[$plugin][$key];
	}
	public function isPluginKey($plugin, $key)
	{
		return isset($this->_plugins[$plugin][$key]) ? true : false;
	}
	public function getPluginVal($plugin, $key, $value)
	{
		return empty($this->_plugins[$plugin][$key][$value]) ? false : $this->_plugins[$plugin][$key][$value];
	}
	public function getPluginVar($plugin, $value)
	{
		return empty($this->_plugins[$plugin]['__construct'][$value]) ? false : $this->_plugins[$plugin]['__construct'][$value];
	}
	public function setPlugin($plugin, $key, $value)
	{
		$this->_plugins[$plugin][$key] = $value;
	}
	public function getLanguagesList()
	{
		return $this->_languagesList;
	}
	public function getTemplates()
	{
		return $this->_templates;
	}
	public function getTemplate($template)
	{
		return in_array($template, $this->_templates) ? $template : $this->getSetting('template');
	}
	public function getUrl()
	{
		return '?' . implode('/', $this->_url);
	}
	public function getUrlVal($value)
	{
		return empty($this->_url[$value]) ? false : $this->_url[$value];
	}
	public function setPluginUrl($value)
	{
		$this->_pluginUrl = $value;
	}
	public function getCookie()
	{
		return empty($_COOKIE['PASSWORD']) ? false : $_COOKIE['PASSWORD'];
	}
	private function getPopup()
	{
		if($this->_popup)
		{
			unset($_SESSION['POPUP']);
			return '<div id="popup">' . $this->_popup . '</div>';
		}
	}
	public function getEditMode()
	{
		return empty($_SESSION['EDITMODE']) ? false : '/edit';
	}
	public function getTitle()
	{
		return $this->_($this->_title);
	}
	public function setTitle($value)
	{
		$this->_title = $value;
	}
	public function getMetaTitle()
	{
		$title = empty($this->_metaTitle) ? $this->_title : $this->_metaTitle;
		return $this->_($title) . ' | ' . $this->getSetting('title');
	}
	public function setMetaTitle($value)
	{
		$this->_metaTitle = $value;
	}
	public function getContent()
	{
		return $this->_content;
	}
	public function setContent($value)
	{
		$this->_content = $value;
	}
	public function getPost($key)
	{
		return empty($_POST[$key]) ? false : stripslashes($_POST[$key]);
	}
	public function isPost($key)
	{
		return isset($_POST[$key]) ? true : false;
	}
	public function getMenu()
	{
		foreach($this->getPositionsPages() as $value)
		{
			if($this->getPageVal($value, 'position') > 0)
			{
				$current = ($this->getUrlVal(1) == $value || $this->getLinkPage('?' . $this->getUrlVal(0)) == $value) ? ' class="current"' : false;
				$blank = ($this->getPageVal($value, 'blank') && !$this->getEditMode()) ? ' target="_blank"' : false;
				$link = ($this->getPageVal($value, 'link') && !$this->getEditMode()) ? $this->getPageVal($value, 'link') : '?page/' . $value . $this->getEditMode();
				@$rows .= '<li><a href="' . $link . '"' . $current . $blank . '>' . $this->getPageVal($value, 'title') . "</a></li>";
			}
		}
		return empty($rows) ? false : '<ul>' . $rows . '</ul>';
	}
	public function getPanel()
	{
		if($this->getCookie() == $this->getSetting('password'))
		{
			if($this->getPage($this->getPost('list')))
			{
				return $this->redirect('?page/' . $this->getPost('list') . $this->getEditMode());
			}
			else
			{
				$panel = '<div id="panel"><ul><li><form method="post"><select name="list" onchange="this.form.submit();">' . $this->selectPage() . '</select></form></li>' . $this->tabs() . '</ul></div><div id="spacing"></div>';
			}
		}
		return @$panel . $this->getPopup();
	}
	public function getLink()
	{
		if($this->getUrlVal(0) == 'page'
		&& $this->getPage($this->getUrlVal(1))
		|| $this->getLinkPage('?' . $this->getUrlVal(0)))
		{
			$url = $this->getLinkPage('?' . $this->getUrlVal(0)) ? $this->getLinkPage('?' . $this->getUrlVal(0)) : $this->getUrlVal(1);
			$link = 'page/' . $url . '/edit';
		}
		else
		{
			$link = 'settings';
		}
		return '<a href="?' . $link . '">' . $this->_('Administration') . '</a>';
	}

	/*
		Importation des données, plugins, langues et templates
	*/

	private function importData()
	{
		$handle = opendir($this->_dataPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_dataPath . $entry)
			&& pathinfo($entry, PATHINFO_EXTENSION) == 'json')
			{
				$array[pathinfo($entry, PATHINFO_FILENAME)] = $this->jsonGetContents($this->_dataPath . $entry);
			}
		}
		closedir($handle);
		return $array;
	}
	private function importPlugins()
	{
		$handle = opendir($this->_pluginsPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_pluginsPath . $entry . '/plugin.json'))
			{
				$array[$entry] = $this->jsonGetContents($this->_pluginsPath . $entry . '/plugin.json');
			}
		}
		closedir($handle);
		return empty($array) ? array() : $array;
	}
	private function listLanguages()
	{
		$handle = opendir($this->_languagesPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_languagesPath . $entry))
			{
				$array[] = pathinfo($entry, PATHINFO_FILENAME);
			}
		}
		closedir($handle);
		return $array;
	}
	private function importLanguages()
	{
		$array = $this->jsonGetContents($this->_languagesPath . $this->getSetting('language') . '.json');
		foreach($this->_plugins as $key => $value)
		{
			if(is_file($file = $this->_pluginsPath . $key . '/languages/' . $this->getSetting('language') . '.json'))
			{
				$array = array_merge($array, $this->jsonGetContents($file));
			}
		}
		return $array;
	}
	private function importTemplates()
	{
		$handle = opendir($this->_templatesPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_templatesPath . $entry . '/index.html'))
			{
				$array[] = $entry;
			}
		}
		closedir($handle);
		return $array;
	}

	/*
		Traitement des données
	*/

	public function jsonGetContents($file)
	{
		return json_decode(file_get_contents($file), true);
	}
	public function jsonPutContents($file, $data)
	{
		return file_put_contents($file, json_encode($data));
	}
	private function pagesExtracts($subkey)
	{
		foreach($this->getData('pages') as $key => $value)
		{
			$array[$value[$subkey]] = strval($key);
		}
		return $array;
	}

	/*
		Constructeur
	*/

	public function builder()
	{
		if($this->getPlugin($this->getUrlVal(0)))
		{
			$plugin = new $this->_url[0];
			$pluginUrl = $this->getUrlVal($plugin->_pluginUrl) ? $this->getUrlVal($plugin->_pluginUrl) : 'home';
			if($this->isPluginKey($this->getUrlVal(0), $pluginUrl))
			{
				if($this->getPluginKey($this->getUrlVal(0), $pluginUrl)
				|| $this->getCookie() == $this->getSetting('password'))
				{
					$plugin->$pluginUrl();
				}
				else
				{
					$plugin = new user;
					$plugin->login();
				}
			}
			$this->setData('settings', $plugin->getData('settings'));
			$this->setTitle($plugin->_title);
			$this->setMetaTitle($plugin->_metaTitle);
			return $this->setContent('<h2>' . $this->getTitle() . '</h2>' . $plugin->_content);
		}
	}

	/*
		Fonctions diverses
	*/

	public function redirect($url)
	{
		header('location:' . $url);
		exit;
	}
	public function _($str)
	{
		return isset($this->_languages[$str]) ? $this->_languages[$str] : $str;
	}
	public function sessionEditMode()
	{
		if($this->getCookie())
		{
			if($this->getUrlVal(0) == 'page'
			&& $this->getUrlVal(2))
			{
				return $_SESSION['EDITMODE'] = true;
			}
			elseif($this->getUrlVal(0) == 'page'
			&& !$this->getUrlVal(2)
			|| $this->getLinkPage('?' . $this->getUrlVal(0)))
			{
				unset($_SESSION['EDITMODE']);
			}
		}
	}
	private function tabs()
	{
		if($this->getUrlVal(0) == 'page'
		&& $this->getPage($this->getUrlVal(1))
		|| $this->getLinkPage('?' . $this->getUrlVal(0)))
		{
			if($this->getUrlVal(2) == 'edit')
			{
				if($this->getPageVal($this->getUrlVal(1), 'link'))
				{
					$url = $this->getPageVal($this->getUrlVal(1), 'link');
					$blank = $this->getPageVal($this->getUrlVal(1), 'blank') ? ' target="_blank"' : false;
					$confirm = (substr($this->getPageVal($this->getUrlVal(1), 'link'), 0, 1) == '?') ? false : ' onclick="return confirm(\'' . $this->_('Attention le lien de redirection mène vers un site externe !') . '\');"';
				}
				else
				{
					$url = '?page/' . $this->getUrlVal(1);
				}
				$page = '<li><a href="' . $url . '"' . @$blank . @$confirm . '>' . $this->_('Mode public') . '</a></li>';
			}
			else
			{
				$url = $this->getLinkPage('?' . $this->getUrlVal(0)) ? $this->getLinkPage('?' . $this->getUrlVal(0)) : $this->getUrlVal(1);
				$page = '<li><a href="?page/' . $url . '/edit">' . $this->_('Mode édition') . '</a></li>';
			}
			$page .= '<li><a href="?page/' . $this->getUrlVal(1) . '/delete" onclick="return confirm(\'' . $this->_('Êtes-vous certain de vouloir supprimer cette page ?') . '\');">' . $this->_('Supprimer') . '</a></li>';
		}
		return '<li><a href="?page/-/add">' . $this->_('Créer') . '</a></li>' .
			@$page .
			'<li><a href="?settings">' . $this->_('Paramètres') . '</a></li>' .
			'<li><a href="?plugins">' . $this->_('Plugins') . '</a></li>' .
			'<li><a href="?user/logout" onclick="return confirm(\'' . $this->_('Êtes-vous certain de vouloir vous déconnecter ?') . '\');">' . $this->_('Déconnexion') . '</a></li>';
	}
	private function selectPage()
	{
		if($this->getUrlVal(0) == 'page'
		&& $this->getPage($this->getUrlVal(1))
		|| $this->getLinkPage('?' . $this->getUrlVal(0)))
		{
			$options = '<option disabled>' . $this->_('Liste des pages') . '</option>';
			$disabled = true;
		}
		else
		{
			$options = '<option selected>' . $this->_('Liste des pages') . '</option>';
			$disabled = false;
		}
		foreach($this->getData('pages') as $key => $value)
		{
			if($this->getUrlVal(1) == $key
			&& $disabled
			|| $this->getLinkPage('?' . $this->getUrlVal(0)) == $key)
			{
				$options .= '<option value="' . $key . '" selected>' . $value['title'] . '</option>';
			}
			else
			{
				$options .= '<option value="' . $key . '">' . $value['title'] . '</option>';
			}
		}
		return $options;
	}
}

class page extends zwii
{
	private $_pagesPath;
	private $_settingsPath;

	public function __construct()
	{
		parent::__construct();
		$this->setPluginUrl(2);
		$this->_pagesPath = $this->getDataPath() . 'pages.json';
		$this->_settingsPath = $this->getDataPath() . 'settings.json';
	}
	public function home()
	{
		if(!$this->getPage($this->getUrlVal(1)))
		{
			return false;
		}
		elseif($this->getPageVal($this->getUrlVal(1), 'link'))
		{
			$this->redirect($this->getPageVal($this->getUrlVal(1), 'link'));
		}
		else
		{
			$metaTitle = $this->getPageVal($this->getUrlVal(1), 'metaTitle') ? $this->getPageVal($this->getUrlVal(1), 'metaTitle') : $this->getPageVal($this->getUrlVal(1), 'title');
			$metaDescription = $this->getPageVal($this->getUrlVal(1), 'metaDescription') ? $this->getPageVal($this->getUrlVal(1), 'metaDescription') : $this->getSetting('description');
			$metaKeywords = $this->getPageVal($this->getUrlVal(1), 'metaKeywords') ? $this->getPageVal($this->getUrlVal(1), 'metaKeywords') : $this->getSetting('keywords');
			$title = $this->getPageVal($this->getUrlVal(1), 'hide') ? false : $this->getPageVal($this->getUrlVal(1), 'title');
			$this->setTitle($title);
			$this->setMetaTitle($metaTitle);
			$this->setDataVal('settings', 'description', $metaDescription);
			$this->setDataVal('settings', 'keywords', $metaKeywords);
			$this->setContent($this->getPageVal($this->getUrlVal(1), 'content', true));
		}
	}
	public function add()
	{
		$key = $this->increment($this->filter('Nouvelle page'));
		$value = array
		(
			'title' => $this->_('Nouvelle page'),
			'position' => 0,
			'hide' => false,
			'blank' => false,
			'link' => false,
			'template' => false,
			'metaTitle' => false,
			'metaDescription' => false,
			'metaKeywords' => false,
			'content' => $this->_('Contenu de la page.')
		);
		$this->setDataVal('pages', $key, $value);
		$this->jsonPutContents($this->_pagesPath, $this->getData('pages'));
		$_SESSION['POPUP'] = $this->_('Nouvelle page créée avec succès !');
		return $this->redirect('?page/' . $key . $this->getEditMode());
	}
	public function edit()
	{
		if(!$this->getPage($this->getUrlVal(1)))
		{
			return false;
		}
		elseif($this->getPost('submit'))
		{
			$key = ($this->getPost('title') == $this->getPageVal($this->getUrlVal(1), 'title')) ? $this->getUrlVal(1) : $this->increment($this->filter($this->getPost('title')));
			$this->removeData('pages', $this->getUrlVal(1));
			$this->setDataVal('pages', $key, $this->newContent());
			$this->jsonPutContents($this->_pagesPath, $this->getData('pages'));
			if($this->getSetting('home') == $this->getUrlVal(1))
			{
				$this->setDataVal('settings', 'home', $key);
				$this->jsonPutContents($this->_settingsPath, $this->getData('settings'));
			}
			return $this->redirect('?page/' . $key . $this->getEditMode());
		}
		else
		{
			$checkedHide = $this->getPageVal($this->getUrlVal(1), 'hide') ? ' checked' : false;
			$checkedBlank = $this->getPageVal($this->getUrlVal(1), 'blank') ? ' checked' : false;
			$this->setTitle('Mode édition');
			$this->setContent
			(
				'<form name="form" method="post">' .
				'<p>' .
				'<label>' . $this->_('Titre de la page') . '</label>' .
				'<input type="text" name="title" value="' . htmlentities($this->getPageVal($this->getUrlVal(1), 'title'), ENT_COMPAT, 'UTF-8') . '" required>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Position dans le menu') . '</label>' .
				'<input type="text" name="position" value="' . $this->getPageVal($this->getUrlVal(1), 'position') . '">' .
				'<div class="tip">' . $this->_('Saisir une valeur supérieure à 0 afin d\'afficher la page dans le menu.') . '</div>' .
				'</p>' .
				'<p>' .
				'<div id="editor"></div>' .
				'<textarea id="hide_editor" name="content" class="hide">' . $this->getPageVal($this->getUrlVal(1), 'content') . '</textarea>' .
				'<script>var editor = new EpicEditor().load();</script>' .
				'</p>' .
				'<div class="tip"><a href="system/markdown/syntax.html" target="_blank">' . $this->_('Syntaxe Markdown') . '</a></div>' .
				'<div id="advanced" class="hide">' .
				'<h3>' . $this->_('Paramètres avancés') . '</h3>' .
				'<p>' .
				'<input type="checkbox" id="hide" name="hide"' . $checkedHide . '><label for="hide" class="checkbox">' . $this->_('Cacher le titre de la page') . '</label>' .
				'</p>' .
				'<p>' .
				'<input type="checkbox" id="blank" name="blank"' . $checkedBlank . '><label for="blank" class="checkbox">' . $this->_('Ouvrir dans un nouvel onglet') . '</label>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Lien de redirection') . '</label>' .
				'<input type="text" name="link" value="' . htmlentities($this->getPageVal($this->getUrlVal(1), 'link'), ENT_COMPAT, 'UTF-8') . '" placeholder="http://">' .
				'<div class="tip">' . $this->_('Redirection automatique de la page vers ce lien.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Template de la page') . '</label>' .
				'<select name="template">' . $this->selectTemplate() . '</select>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Balise méta titre') . '</label>' .
				'<input type="text" name="metaTitle" value="' . htmlentities($this->getPageVal($this->getUrlVal(1), 'metaTitle'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Remplace le contenu de la balise méta titre défini dans les paramètres.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Balise méta description') . '</label>' .
				'<input type="text" name="metaDescription" value="' . htmlentities($this->getPageVal($this->getUrlVal(1), 'metaDescription'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Remplace le contenu de la balise méta description défini dans les paramètres.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Balise méta mots clés') . '</label>' .
				'<input type="text" name="metaKeywords" value="' . htmlentities($this->getPageVal($this->getUrlVal(1), 'metaKeywords'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Remplace le contenu de la balise méta mots clés défini dans les paramètres.') . '</div>' .
				'</p>' .
				'</div>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Enregistrer') . '"> ' .
				'<input type="button" value="' . $this->_('Paramètres avancés') . '" onclick="showHide(\'advanced\');">' .
				'</p>' .
				'</form>'
			);
		}
	}
	public function delete()
	{
		if($this->getPage($this->getUrlVal(1)))
		{
			if($this->getUrlVal(1) == $this->getSetting('home'))
			{
				$_SESSION['POPUP'] = $this->_('Impossible de supprimer la page d\'accueil !');
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('Page supprimée avec succès !');
				$this->removeData('pages', $this->getUrlVal(1));
				$this->jsonPutContents($this->_pagesPath, $this->getData('pages'));
			}
			return $this->redirect('?page/' . $this->getSetting('home') . $this->getEditMode());
		}
	}
	private function increment($key)
	{
		$i = 2;
		$newKey = $key;
		while($this->getPage($newKey))
		{
			$newKey = $key . '-' . $i;
			$i++;
		}
		return $newKey;
	}
	private function filter($str)
	{
		$str = strtolower($str);
		$search = explode(',', 'á,à,â,ä,ã,å,ç,é,è,ê,ë,í,ì,î,ï,ñ,ó,ò,ô,ö,õ,ú,ù,û,ü,ý,ÿ, ');
		$replace = explode(',', 'a,a,a,a,a,a,c,e,e,e,e,i,i,i,i,n,o,o,o,o,o,u,u,u,u,y,y,-');
		$str = str_replace($search, $replace, $str);
		$str = preg_replace('#[^a-z0-9-]#', '', $str);
		return $str;
	}
	private function newContent()
	{
		$title = $this->getPost('title') ? $this->getPost('title') : $this->_('Sans titre');
		if($this->getPost('link')
		&& $this->getLinkPage($this->getPost('link'))
		&& $this->getLinkPage($this->getPost('link')) !== $this->getUrlVal(1))
		{
			$link = $this->getPageVal($this->getUrlVal(1), 'link');
			$_SESSION['POPUP'] = $this->_('Page enregistrée avec succès, sauf le lien de redirection car il est déjà utilisé dans une autre page !');
		}
		else
		{
			$link = $this->getPost('link');
			$_SESSION['POPUP'] = $this->_('Page enregistrée avec succès !');
		}
		$value = array
		(
			'title' => $title,
			'position' => intval($this->getPost('position')),
			'hide' => $this->getPost('hide'),
			'blank' => $this->getPost('blank'),
			'link' => $link,
			'template' => $this->getPost('template'),
			'metaTitle' => $this->getPost('metaTitle'),
			'metaDescription' => $this->getPost('metaDescription'),
			'metaKeywords' => $this->getPost('metaKeywords'),
			'content' => $this->getPost('content')
		);
		return $value;
	}
	private function selectTemplate()
	{
		foreach($this->getTemplates() as $value)
		{
			$selected = ($this->getPageVal($this->getUrlVal(1), 'template') == $value) ? ' selected' : false;
			@$options .= '<option value="' . $value . '"' . $selected . '>' . $value . '</option>';
		}
		$default = $selected ? false : ' selected';
		return '<option value=""' . $default . '>' . $this->_('Template par défaut') . '</option>' . $options;
	}
}

class settings extends zwii
{
	private $_settingsPath;

	public function __construct()
	{
		parent::__construct();
		$this->_settingsPath = $this->getDataPath() . 'settings.json';
	}

	public function home()
	{
		if($this->getPost('submit'))
		{
			$this->newPluginsSettings();
			$this->setData('settings', $this->newSettings());
			$this->jsonPutContents($this->_settingsPath, $this->getData('settings'));
			$_SESSION['POPUP'] = $this->_('Paramètres enregistrés avec succès !');
			return $this->redirect($this->getUrl());

		}
		else
		{
			$this->setTitle('Paramètres');
			$this->setContent
			(
				'<h3>' . $this->_('Paramètres généraux') . '</h3>' .
				'<form name="form" method="post">' .
				'<p>' .
				'<label>' . $this->_('Titre du site') . '</label>' .
				'<input type="text" name="title" value="' . htmlentities($this->getSetting('title'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Le titre du site englobe également la balise méta titre.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Nouveau mot de passe') . '</label>' .
				'<input type="text" name="password" value="">' .
				'<div class="tip">' . $this->_('Laisser vide pour ne pas changer le mot de passe d\'administration.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Page d\'accueil') . '</label>' .
				'<select name="home">' .
				$this->selectHome() .
				'</select>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Template par défaut') . '</label>' .
				'<select name="template">' .
				$this->selectTemplate() .
				'</select>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Langage du site') . '</label>' .
				'<select name="language">' .
				$this->selectLanguage() .
				'</select>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Bas de page') . '</label>' .
				'<input type="text" name="footer" value="' . htmlentities($this->getSetting('footer'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Texte en bas de page (merci de laisser une petite trace de Zwii).') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Balise méta description') . '</label>' .
				'<input type="text" name="description" value="' . htmlentities($this->getSetting('description'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Description de 150 caractères maximum.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Balise méta mots clés') . '</label>' .
				'<input type="text" name="keywords" value="' . htmlentities($this->getSetting('keywords'), ENT_COMPAT, 'UTF-8') . '">' .
				'<div class="tip">' . $this->_('Mots clés séparés par des virgules.') . '</div>' .
				'</p>' .
				'<p>' .
				'<label>' . $this->_('Version de Zwii') . '</label>' .
				'<input type="text" name="version" value="' . self::VERSION . '" readonly>' .
				'</p>' .
				'<div id="plugins" class="hide">' .
				'<h3>' . $this->_('Paramètres des plugins') . '</h3>' .
				$this->pluginsSettings() .
				'</div>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Enregistrer') . '"> ' .
				'<input type="button" value="' . $this->_('Paramètres des plugins') . '" onclick="showHide(\'plugins\');">' .
				'</p>' .
				'</form>'
			);
		}
	}
	private function newSettings()
	{
		foreach($this->getData('settings') as $key => $value)
		{
			if($key == 'password')
			{
				$array[$key] = $this->getPost($key) ? sha1($this->getPost($key)) : $this->getSetting($key);
			}
			else
			{
				$array[$key] = $this->getPost($key);
			}
		}
		return $array;
	}
	private function newPluginsSettings()
	{
		foreach($this->getPlugins() as $key => $value)
		{
			if(!empty($value['__construct']))
			{
				foreach($value['__construct'] as $sub_key => $sub_value)
				{
					$array[$key][$sub_key] = $this->isPost($key . $sub_key) ? $this->getPost($key . $sub_key) : $sub_value;
				}
				$this->setPlugin($key, '__construct', $array[$key]);
				$this->jsonPutContents($this->getPluginsPath() . $key . '/plugin.json', $this->getPlugin($key));
			}
		}
	}
	private function selectTemplate()
	{
		foreach($this->getTemplates() as $value)
		{
			$selected = ($this->getSetting('template') == $value) ? ' selected' : false;
			@$options .= '<option value="' . $value . '"' . $selected . '>' . $value . '</option>';
		}
		return $options;
	}
	private function selectHome()
	{
		foreach($this->getData('pages') as $key => $value)
		{
			$selected = ($this->getSetting('home') == $key) ? ' selected' : false;
			@$options .= '<option value="' . $key . '"' . $selected . '>' . $value['title'] . '</option>';
		}
		return $options;
	}
	private function selectLanguage()
	{
		foreach($this->getLanguagesList() as $value)
		{
			$selected = ($this->getSetting('language') == $value) ? ' selected' : false;
			@$options .= '<option value="' . $value . '"' . $selected . '>' . $value . '</option>';
		}
		return $options;
	}
	private function pluginsSettings()
	{
		foreach($this->getPlugins() as $key => $value)
		{
			if(!empty($value['__construct'])
			&& count($value['__construct']) > 1)
			{
				foreach($value['__construct'] as $sub_key => $sub_value)
				{
					@$settings .= ($sub_key == 'name') ? '<h4>' . $this->_($sub_value) . '</h4>' : '<p><label>' . $this->_($sub_key) . '</label><input type="text" name="' . $key . $sub_key . '" value="' . $sub_value . '"></p>';
				}
			}
		}
		return empty($settings) ? '<p>' . $this->_('Aucun plugin.') . '</p>' : $settings;
	}
}

class plugins extends zwii
{
	public function __construct()
	{
		parent::__construct();
	}
	public function home()
	{
		foreach($this->getPlugins() as $key => $value)
		{
			@$rows .= $this->getPluginKey($key, '__construct') ? '<tr><td><a href="?' . $key . '">' . $this->_($this->getPluginVar($key, 'name')) . '</a></td></tr>' : false;
		}
		$rows = empty($rows) ? '<tr><td>' . $this->_('Aucun plugin.') . '</td></tr>' : $rows;
		$this->setTitle('Plugins');
		$this->setContent
		(
			'<table>' .
			'<thead>' .
			'<tr>' .
			'<th>' . $this->_('Liste des plugins') . '</th>' .
			'</tr>' .
			'</thead>' .
			'<tbody>' .
			$rows .
			'</tbody>' .
			'</table>'
		);
	}
}

class user extends zwii
{

	public function __construct()
	{
		parent::__construct();
	}
	public function logout()
	{
		setcookie('PASSWORD');
		session_destroy();
		return $this->redirect('./');
	}
	public function login()
	{
		if($this->getPost('submit'))
		{
			if(sha1($this->getPost('password')) == $this->getSetting('password'))
			{
				$time = $this->getPost('time') ? 0 : time()+10*365*24*60*60;
				setcookie('PASSWORD', sha1($this->getPost('password')), $time);
				return $this->redirect($this->getUrl());
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('Mot de passe incorrect !');
				return $this->redirect($this->getUrl());
			}
		}
		else
		{
			$this->setTitle('Connexion');
			$this->setContent
			(
				'<form name="form" method="post">' .
				'<p>' .
				'<input type="password" name="password" class="little" placeholder="' . $this->_('Mot de passe') . '" required>' .
				'</p>' .
				'<p>' .
				'<input type="checkbox" id="time" name="time"><label for="time" class="checkbox"> ' . $this->_('Me connecter automatiquement lors de mes prochaines visites.') . '</label>' .
				'</p>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Connexion') . '">' .
				'</p>' .
				'</form>'
			);
		}
	}
}

?>