<?php

/*
	Copyright (C) 2009-2013, Rémi Jean (zwiicms@outlook.com)
	<http://zwiicms.com/>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General License for more details.

	You should have received a copy of the GNU General License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class files_manager extends zwii
{
	private $_uploadPath;

	public function __construct()
	{
		parent::__construct();
		$this->_uploadPath = $this->getPluginVar('files_manager', 'uploadPath') ? $this->getPluginVar('files_manager', 'uploadPath') : './';
		if(!is_dir($this->_uploadPath))
		{
			mkdir($this->_uploadPath);
		}
	}
	public function home()
	{
		if($this->getPost('submit'))
		{
			$this->upload();
			return $this->redirect($this->getUrl());
		}
		else
		{
			$this->setTitle('Gestionnaire de fichiers');
			$this->setContent
			(
				'<form name="form" method="post" enctype="multipart/form-data">' .
				'<h3>' . $this->_('Envoyer un fichier') . '</h3>' .
				'<p>' .
				'<input type="file" name="file">' .
				'<div class="tip">' . $this->_('Taille maximale autorisée par le serveur :') . ' ' . ini_get('upload_max_filesize') . '</div>' .
				'</p>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Envoyer') . '">' .
				'</p>' .
				'</form>' .
				'<h3>' . $this->_('Mes fichiers') . '</h3>' .
				'<table>' .
				'<tr><th>' . $this->_('Nom') . '</th><th>' . $this->_('Taille') . '</th><th>' . $this->_('Actions') . '</th></tr>' .
				$this->listFiles() .
				'</table>'
			);
		}
	}
	public function rename()
	{
		if(!file_exists($this->_uploadPath . $this->getUrlVal(2)))
		{
			return false;
		}
		elseif($this->getPost('submit'))
		{
			if(!$this->getPost('name'))
			{
				$_SESSION['POPUP'] = $this->_('Impossible de renommer le fichier !');
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('Fichier renommé avec succès !');
				$extension = pathinfo($this->getUrlVal(2), PATHINFO_EXTENSION);
				$name = $this->getPost('name') . '.' . $extension;
				$name = ($name == $this->getUrlVal(2)) ? $this->getPost('name') : $this->increment($this->filter($this->getPost('name')), $extension);
				$file = $this->_uploadPath . $name . '.' . $extension;
				rename($this->_uploadPath . $this->getUrlVal(2), $file);
			}
			return $this->redirect('?files_manager');
		}
		else
		{
			$name = pathinfo($this->getUrlVal(2), PATHINFO_FILENAME);
			$this->setTitle('Renommer un fichier');
			$this->setContent
			(
				'<form name="form" method="post">' .
				'<p>' .
				'<label>' . $this->_('Nom') . '</label>' .
				'<input type="text" name="name" value="' . $name . '">' .
				'</p>' .
				'<p>' .
				'<input type="submit" name="submit" value="' . $this->_('Enregistrer') . '"> ' .
				'<input type="button" value="' . $this->_('Retour') . '" onclick="history.back();">' .
				'</p>' .
				'</form>'
			);
		}
	}
	public function delete()
	{
		if(file_exists($this->_uploadPath . $this->getUrlVal(2)))
		{
			if(unlink($this->_uploadPath . $this->getUrlVal(2)))
			{
				$_SESSION['POPUP'] = $this->_('Fichier supprimé avec succès !');
			}
			else
			{
				$_SESSION['POPUP'] = $this->_('Impossible de supprimer le fichier !');
			}
			return $this->redirect('?files_manager');
		}
	}
	private function upload()
	{
		if($_FILES['file']['size'] > 0)
		{
			$extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
			$name = pathinfo($_FILES['file']['name'], PATHINFO_FILENAME);
			$name = $this->increment($this->filter($name), $extension);
			$file = $this->_uploadPath . $name . '.' . $extension;
			if(false !== move_uploaded_file($_FILES['file']['tmp_name'], $file))
			{
				return $_SESSION['POPUP'] = $this->_('Fichier téléchargé avec succès !');
			}
			else
			{
				return $_SESSION['POPUP'] = $this->_('Impossible de télécharger le fichier !');
			}
		}
	}
	private function listFiles()
	{
		$handle = opendir($this->_uploadPath);
		while(false !== ($entry = readdir($handle)))
		{
			if(is_file($this->_uploadPath . $entry))
			{
				$filesize = round(filesize($this->_uploadPath . $entry) / 1024);
				@$files .= '<tr>' .
					'<td>' . $entry . '</td>' .
					'<td>' . $filesize . ' ko</td>' .
					'<td>' .
					'<a href="' . $this->_uploadPath . $entry . '" target="_blank">' . $this->_('Afficher') . '</a> ' .
					'<a href="?files_manager/rename/' . $entry . '">' . $this->_('Renommer') . '</a> ' .
					'<a href="?files_manager/delete/' . $entry . '" onclick="return confirm(\'' . $this->_('Êtes-vous certain de vouloir supprimer ce fichier ?') . '\')">' . $this->_('Supprimer') . '</a> ' .
					'</td>' .
					'</tr>';
			}
		}
		closedir($handle);
		return empty($files) ? '<tr><td colspan="3">' . $this->_('Aucun fichier.') . '</td></tr>' : $files;
	}
	private function increment($name, $extension)
	{
		$i = 2;
		$newName = $name;
		while(false !== file_exists($this->_uploadPath . $newName . '.' . $extension))
		{
			$newName = $name . '(' . $i . ')';
			$i++;
		}
		return $newName;
	}
	private function filter($str)
	{
		$str = strtolower($str);
		$search = explode(',', 'á,à,â,ä,ã,å,ç,é,è,ê,ë,í,ì,î,ï,ñ,ó,ò,ô,ö,õ,ú,ù,û,ü,ý,ÿ, ');
		$replace = explode(',', 'a,a,a,a,a,a,c,e,e,e,e,i,i,i,i,n,o,o,o,o,o,u,u,u,u,y,y,-');
		$str = str_replace($search, $replace, $str);
		$str = preg_replace('#[^a-z0-9-_.()]#', '', $str);
		return $str;
	}
}

?>