/*!
 * Origami jQuery plugin
 *
 * GitHub Repository: https://github.com/digital-telepathy/origami
 * @author digital-telepathy
 * 
 * Copyright (C) 2013 digital-telepathy  (email : support@digital-telepathy.com)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
var Origami=function(a,b){this._interacting=false;this._interactingOffset={top:-1,left:-1};this.dimensions={width:-1,outerWidth:-1,height:-1,outerHeight:-1};this.elements={};this.hovering=false;this.isOpen=false;this.namespace="origami";this.offset={left:-1,top:-1};this.options={method:'css',kami:'>.kami',speed:350,touch:false};this.selectors={body:'body',window:window};this.initialize(a,b)};(function($,j,k){var l=(function(){var a,v=3,div=document.createElement('div'),all=div.getElementsByTagName('i');while(div.innerHTML='<!--[if gt IE '+(++v)+']><i></i><![endif]-->',all[0]);return v>4?v:a}());Origami.prototype._bindEvents=function(){var b=this;this.elements.origami.on('mouseenter mouseleave',function(a){b.hover(a)});this.elements.origami.on('click',function(){if(!b._interactionMoving){b.toggle()}b._interacting=false;b._interactionMoving=false});if(j.addEventListener){this.elements.origami[0].addEventListener('touchstart',function(a){b._touchStart(a)},false);this.elements.origami[0].addEventListener('touchmove',function(a){b._touchMove(a)},false);this.elements.origami[0].addEventListener('touchend',function(a){b._touchEnd(a)},false)}};Origami.prototype._build=function(){var h=this;this.elements.kami.each(function(a){var b=h.elements.kami.eq(a);b.wrap('<div class="kami-wrapper" />');var c=b.parent();b.data('$wrapper',c);var d=b.clone().appendTo(c);b.data('$peek',d);d.addClass('kami-peek');var e=$('<span class="kami-shadow" />').appendTo(d);b.data('$shadow',e);d.wrap('<div class="kami-peek-mask" />');var f=d.parent();b.data('$peekMask',f);b.wrap('<div class="kami-mask" />');var g=b.parent();b.data('$kamiMask',g);if(a==0)c.addClass('on-top');c.css($.extend({zIndex:(h.elements.kami.length-a)*10},h._prefixCSS({perspective:(h.elements.origami.width()*4)+"px"})));f.add(g).css(h._prefixCSS({'backface-visibility':'hidden','transform-style':'preserve-3d','transform-origin':'0 0'}));g.css(h._prefixCSS({transform:'rotateY('+(a==0?0:90)+'deg)','transform-origin':'100% 0'}));e.css(h._prefixCSS({transition:'opacity '+h.options.speed+'ms linear'}))});this.offset=this.elements.origami.offset();this.dimensions={width:this.elements.origami.width(),outerWidth:this.elements.origami.outerWidth(),height:this.elements.origami.height(),outerHeight:this.elements.origami.outerHeight()}};Origami.prototype._getElements=function(){var e=this;$.each(this.selectors,function(c,d){if($.isPlainObject(d)){e.elements[c]=e.elements[c]||{};$.each(d,function(a,b){e.elements[c][a]=$(b)})}else{e.elements[c]=$(d)}});this.elements.kami=$(this.options.kami,this.elements.origami)};Origami.prototype._getKami=function(a){var b={kami:this.elements.kami.eq(a)};b.wrapper=b.kami.data('$wrapper');b.kamiMask=b.kami.data('$kamiMask');b.peekMask=b.kami.data('$peekMask');b.shadow=b.kami.data('$shadow');return b};Origami.prototype._hasCSSFeature=function(a){var b=false,domPrefixes='Webkit Moz ms O Khtml'.split(' '),elm=document.createElement('div'),featurenameCapital=null;a=a.toLowerCase();if(elm.style[a]){b=true}if(b===false){featurenameCapital=a.charAt(0).toUpperCase()+a.substr(1);for(var i=0;i<domPrefixes.length;i++){if(elm.style[domPrefixes[i]+featurenameCapital]!==k){b=true;break}}}return b};Origami.prototype._run=function(){var a=[];for(var i=0;i<arguments.length;i++){a.push(arguments[i])}var b=a[0];var c=a.length>1?a.slice(1):[];if(typeof(this[b])=='function'){return this[b].apply(this,c)}else if(typeof(this[b])!='undefined'){return this[b]}};Origami.prototype._prefixCSS=function(a,b){var b=b||false;var c=['moz','ms','o','webkit'];if(l&&l<9)return a;for(var d in a){var e=a[d];for(var p in c){valuePrefix=b?'-'+c[p]+'-':"";a['-'+c[p]+'-'+d]=valuePrefix+e}}return a};Origami.prototype._touchEnd=function(a){if(this.options.touch===false)return false;this._interacting=false;this._interactingOffset.end=this._touchOffset(a);if(this._interactionMoving){var b=Math.abs(this._interactingOffset.left/this.dimensions.outerWidth)>=0.33;if(b&&this.isOpen){this.close(0)}else if(b&&!this.isOpen){this.open(0)}else if(!b&&this.isOpen){this.open(0)}else if(!b&&!this.isOpen){this.close(0)}}};Origami.prototype._touchMove=function(d){if(this.options.touch===false)return false;if(this._interacting){d.preventDefault();this._interactionMoving=true;var e=this._touchOffset(d),self=this;this._interactingOffset.top=e.top-this._interactingOffset.start.top;this._interactingOffset.left=e.left-this._interactingOffset.start.left;this.elements.kami.each(function(a){var b=self._getKami(a);var c=(e.left-self.offset.left)/self.dimensions.outerWidth;b.wrapper.css('z-index',((c<=0.5)?(a+1):(self.elements.kami.length-a))*10);if(a==0){b.peekMask.css(self._prefixCSS({transform:'rotateY('+Math.max(-90,Math.min(((c*180)-180),0))+'deg)'}));b.shadow.css('opacity',((1-c)/4))}if(a==1){b.kamiMask.css(self._prefixCSS({transform:'rotateY('+Math.max(Math.min((c*180),90),0)+'deg)'}))}})}};Origami.prototype._touchOffset=function(a){var b={top:-1,left:-1};if(a.touches){if(a.touches.length){if(a.touches[0].pageY)b.top=a.touches[0].pageY;if(a.touches[0].pageX)b.left=a.touches[0].pageX}}else{b.top=a.screenY;b.left=a.screenX}return b};Origami.prototype._touchStart=function(c){var d=this;if(this.options.touch===false)return false;this._interacting=true;this._interactionMoving=false;var e=this._touchOffset(c);this._interactingOffset={top:e.top,left:e.left,start:{top:e.top,left:e.left}};this.elements.kami.each(function(a){var b=d._getKami(a);b.peekMask.add(b.kamiMask).add(b.shadow).css(d._prefixCSS({transition:'transform 0ms linear'},true));b.wrapper.css(d._prefixCSS({transition:'z-index 0ms 0ms linear'}))})};Origami.prototype.close=function(c){var d=this;var c=c||(d.options.speed/3)*2;this.isOpen=false;this.elements.origami.removeClass('open hover');this.elements.kami.eq(0).data('$wrapper').show();this.elements.kami.each(function(a){var b=d._getKami(a);b.wrapper.css($.extend(d._prefixCSS({transition:"z-index 0s "+c+"ms"}),{zIndex:(d.elements.kami.length-a)*10}));if(a==1){b.kamiMask.css($.extend(d._prefixCSS({transition:'transform '+c+'ms 0ms linear'},true),d._prefixCSS({transform:'rotateY(90deg)'})))}b.peekMask.css($.extend(d._prefixCSS({transition:'transform '+(d.options.speed-c)+'ms '+c+'ms linear'},true),d._prefixCSS({transform:'rotateY(0deg)'})))});this.elements.kami.eq(0).data('$shadow').css($.extend(this._prefixCSS({transition:'opacity '+(d.options.speed-c)+'ms '+c+'ms linear'}),{opacity:0}));if(this.options.method=='animate'){this.elements.kami.each(function(a){var b=d._getKami(a);b.wrapper.css({opacity:a%2}).animate({opacity:(a+1)%2,zIndex:(d.elements.kami.length-a)*10},d.options.speed)})}setTimeout(function(){d._interacting=false},this.options.speed-c)};Origami.prototype.hover=function(a){if(this.isOpen||this._interacting)return false;this.elements.origami.removeClass('hover');if(a!=k&&a.type=='mouseenter'){this.elements.origami.addClass('hover')}this.hovering=this.elements.origami.hasClass('hover');var b={};if(this.hovering){b=$.extend(this._prefixCSS({'transition':'transform '+(this.options.speed/3)+'ms linear'},true),this._prefixCSS({'transform':'rotateY(-30deg)'}))}else{b=$.extend(this._prefixCSS({'transition':'transform '+this.options.speed+'ms linear'},true),this._prefixCSS({'transform':'rotateY(0deg)'}))}this.elements.kami.eq(0).data('$peekMask').css(b);var c={};if(this.hovering){c=$.extend({opacity:0.1},this._prefixCSS({transition:"opacity "+(this.options.speed/3)+"ms linear"}))}else{c=$.extend({opacity:0},this._prefixCSS({transition:"opacity "+this.options.speed+"ms linear"}))}this.elements.kami.eq(0).data('$shadow').css(c)};Origami.prototype.initialize=function(a){this.options=$.extend(this.options,arguments[1][0]||{},$(a).data());if(!this._hasCSSFeature('animation')){this.options.method="animate"}this.selectors.origami=a;this._getElements();this._build();this._bindEvents()};Origami.prototype.open=function(c){var d=this;var c=c||(d.options.speed/3)*2;this.isOpen=true;this.elements.origami.removeClass('hover').addClass('open');this.elements.kami.each(function(a){var b=d._getKami(a);b.wrapper.css($.extend(d._prefixCSS({transition:"z-index 0s "+c+"ms"}),{zIndex:(a+1)*10}));if(a==0){b.peekMask.css($.extend(d._prefixCSS({transition:'transform '+c+'ms 0ms linear'},true),d._prefixCSS({transform:'rotateY(-90deg)'})))}b.kamiMask.css($.extend(d._prefixCSS({transition:'transform '+d.options.speed+'ms '+c+'ms ease-out'},true),d._prefixCSS({transform:'rotateY(0deg)'})))});this.elements.kami.eq(0).data('$shadow').css($.extend({opacity:0.25},this._prefixCSS({transition:"opacity "+c+"ms 0ms linear"})));if(this.options.method=='animate'){this.elements.kami.each(function(a){var b=d._getKami(a);b.wrapper.css({opacity:(a+1)%2}).animate({opacity:a%2,zIndex:(a+1)*10},d.options.speed)})}};Origami.prototype.option=function(a,b){if(b!=k)this.options[a]=b;return this.options[a]};Origami.prototype.toggle=function(){if(this.isOpen){this.close()}else{this.open()}};$.extend($.fn,{origami:function(){var d=action=arguments;var e=this;this.each(function(a){var b=$.data(this,'Origami');if(!b){b=new Origami(this,d);$.data(this,'Origami',b)}if(action.length>0){var c=b._run.apply(b,action);if(typeof(c)!='undefined'){e=c}}});return e}})})(jQuery,window,null);